<?php namespace Visiosoft\SiteModule\Site\Listener\webhook;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\webhook\ErrorSuspendSiteForWebhook;
use Visiosoft\SiteModule\Site\Event\webhook\SuspendedSiteForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionDeletedForWebhook;

class DeletedSubscriptionForWebhook
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionDeletedForWebhook $event)
    {
        $subscription = $event->getSubscription();

        $sites = $this->site->getSiteForSubscription($subscription->id);

        foreach ($sites as $site) {
            $response = array_first(event(new SuspendSite($site, 'true')));

            if (!$response['status']) {
                $site->updateError($response['message']);


                event(new ErrorSuspendSiteForWebhook($site));
            } else {
                $site->update([
                    'suspend_at' => date('Y-m-d H:i:s'),
                ]);

                event(new SuspendedSiteForWebhook($site));
            }
        }
    }
}
