<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\CreatingSite;
use Visiosoft\SiteModule\Site\Event\ErrorCreateSite;


class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder, MessageBag $message)
    {

        if (!$builder->canSave()) {
            return;
        }
        $builder->saveForm();

        $site = $builder->getFormEntry();

        $response = array_first(event(new BuildSite($site)));


        if (!$response['status']) {
            $site->update([
                'status' => 'error',
                'message' => $response['message']
            ]);

            event(new ErrorCreateSite($site));
        } else {
            $site->update(['status' => 'pending']);

            event(new CreatingSite($site));
        }
    }
}
