<?php namespace Visiosoft\SiteModule\Site\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface SiteRepositoryInterface extends EntryRepositoryInterface
{
    /**
     * @param $subdomain
     * @return mixed
     */
    public function findBySubdomain($subdomain);

    /**
     * @param $id
     * @return mixed
     */
    public function unsuspend($id);

    /**
     * @param $user_id
     * @return mixed
     */
    public function findByAssing($user_id, $type = null);

    /**
     * @param $domain
     * @return mixed
     */
    public function editDomain($domain);

    /**
     * @param $id
     * @return mixed
     */
    public function getSiteForSubscription($id);

    /**
     * @param $subdomain
     * @param $user
     * @param $password
     * @return mixed
     */
    public function createSite($subdomain, $user, $password, $params = []);

    /**
     * @param $day
     * @return mixed
     */
    public function getUnguidedSitesWithDay($day);

    /**
     * @return mixed
     */
    public function getPendingSites();
}
