<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSiteCreateSiteStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'site',
        'title_column' => 'subdomain_name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subdomain_name' => [
            'required' => true,
            'unique' => true,
        ],
        'assign' => [
            'required' => true,
        ],
        'password' => [
            'required' => true,
        ],
        'suspend_at',
        'update_at',
        'enabled',
        'type',
        'status',
    ];

}
