<?php namespace Visiosoft\CloudsiteModule\Site\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class SiteTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'subdomain'=> [
            'value' => '<a href="http://{entry.subdomain}.openclassify.com">{entry.subdomain}.openclassify.com</a>',
        ],'user'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'unsuspend' => [
            'icon' => 'fa fa-eye',
            'type' => 'success',
            'href' => 'admin/cloudsite/unsuspend/{entry.id}',
            'text' => 'visiosoft.module.cloudsite::button.unsuspend'
        ],
        'suspend' => [
            'icon' => 'fa fa-eye-slash',
            'type' => 'default',
            'href' => 'admin/cloudsite/suspend/{entry.id}',
            'text' => 'visiosoft.module.cloudsite::button.suspend'
        ],
        'update' => [
            'icon' => 'fa fa-refresh',
            'type' => 'warning',
            'href' => 'admin/cloudsite/update/{entry.id}',
            'text' => 'visiosoft.module.cloudsite::button.update'
        ],

    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
