<?php namespace Visiosoft\CloudsiteModule\Site;

use Anomaly\UsersModule\User\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CloudsiteModule\Site\Contract\SiteInterface;
use Anomaly\Streams\Platform\Model\Cloudsite\CloudsiteSitesEntryModel;

class SiteModel extends CloudsiteSitesEntryModel implements SiteInterface
{
    public function getSite($id)
    {
        return $this->find($id);
    }

    public function getMySites()
    {
        return $this->where('user_id', Auth::id())->get();
    }

    public function deleteSite($id)
    {
        $this->find($id)->delete();
    }

    public function createSite($subdomain, $user_id, $password, $plan)
    {
        return $this->create(
            [
                'subdomain' => $subdomain,
                'user_id' => $user_id,
                'password' => $password,
                'plan_id' => $plan
            ]
        );
    }

    public function updateBySubdomain($subdomain, $newparams)
    {
        return
            $this->where('subdomain', $subdomain)
                ->update($newparams);
    }

    public function getPendingSites()
    {
        $date = new Carbon;
        $date->subDays(7);
        return $this
            ->where('status', 'pending')
            ->where('created_at', '>', $date->toDateTimeString())
            ->get();
    }

    public function getSitesBySubdomain($subdomain)
    {
        return
            $this->where('subdomain', $subdomain)->first();
    }

}
