<?php namespace Visiosoft\CloudsiteModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\User;
use Visiosoft\CloudsiteModule\Site\Event\CreateSite;
use Visiosoft\ProfileModule\Profile\Event\SiteStatusControl;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CloudsiteModule\Site\Event\last3days;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\CloudsiteModule\Site\Event\DeleteSite;
use Visiosoft\CloudsiteModule\Site\Event\SendNotificationUser;
use Visiosoft\CloudsiteModule\Site\SiteModel;
use Visiosoft\ProfileModule\Profile\sites\SitesFormBuilder;
use Visiosoft\SubscriptionsModule\User\UserModel;


class SitesController extends PublicController
{
    private $settings;
    private $model;

    public function __construct(Dispatcher $events, SettingRepositoryInterface $settingRepository, SiteModel $model)
    {
        $this->events = $events;
        $this->settings = $settingRepository;
        $this->model = $model;
    }

    public function create(SiteModel $siteModel, Request $request, SitesFormBuilder $form)
    {
        $error = $form->build()->validate()->getFormErrors()->getMessages();
        if (!empty($error)) {
            return redirect()->back();
        }

        $user = UserModel::query()->find(Auth::id());
        $active_subscriptions = $user->activeSubscriptions();

        if (count($active_subscriptions) != 0) {

            $plans = $active_subscriptions->pluck('id');

            foreach ($plans as $plan) {
                $whereSite = $siteModel->where('plan_id', $plan)->first();
                if (!$whereSite) {
                    $request = $request->all();
                    $this->model->create(
                        [
                            'subdomain' => $request['subdomain'],
                            'user_id' => Auth::id(),
                            'plan_id' => $plan,
                        ]
                    );
                    $request['user'] = $user;
                    $request['username'] = $user->username;
                    $request['email'] = $user->email;
                    $request['password'] = str_random(12);
                    $this->events->dispatch(new CreateSite($request, $this->settings));
                    return redirect('/profile/subscription')->with('success', [trans('visiosoft.module.cloudsite::message.created_site.message')]);
                    break;
                }
            }
            return redirect('/profile/subscription')->with('error', [trans('visiosoft.module.cloudsite::message.buy_subscription_warning.message')]);
        } else {
            return redirect('/profile/subscription')->with('error', [trans('visiosoft.module.cloudsite::message.buy_subscription_warning.message')]);
        }
    }

    public function delete($id)
    {
        $subdomain = $this->model->getSite($id)->subdomain;
        $this->events->dispatch(new DeleteSite($subdomain, $this->settings));
        $this->model->deleteSite($id);
        return redirect('/profile')->with('success', [trans('visiosoft.module.cloudsite::message.deleted_site.message')]);
    }

    public function isActivated(User $user)//Cron a baqlanacak
    {
        $activated_sites = array();

        $pendingSites = $this->model->getPendingSites();
        foreach ($pendingSites as $pending) {


            $result = $this->events->dispatch(new SiteStatusControl($pending->response_id, $this->settings));
            if (isset($result[0]['result']) and $result[0]['result'] == "SUCCESS") {
                $user = $user->find($pending->user_id);

                $detail = array();
                $detail['subdomain'] = $pending->subdomain;
                $detail['user'] = $user;
                $detail['loginDetail'] = [
                    'username' => $user->username,
                    'email' => $user->email,
                    'password' => $pending->password,
                ];
                $this->events->dispatch(new SendNotificationUser($detail));//mail göndermeyi tetikle

                $this_site = $this->model->getSite($pending->id);//aktif olmuş siteyi bul
                $this_site->update(['status' => 'active']);//siteyi aktif olarak belirt
                $activated_sites[] = $pending->subdomain;
            }
        }

        return response()->json(['status' => 'success', 'activated' => $activated_sites]);
    }

}
