<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCloudsiteCreateSitesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'sites',
        'title_column' => 'subdomain',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'subdomain' => [
            'required' => true,
            'unique' => true,
        ],
        'user',
        'password',
        'status',
        'response_id',
        'plan'
    ];

}
