<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class SiteModulePlugin extends Plugin
{
    public $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'findByAssing',
                function ($user_id) {
                    if (!$subdomains = $this->site->findByAssing($user_id)) {
                        return null;
                    }
                    return $subdomains;
                }
            )
        ];
    }
}
