<?php namespace Visiosoft\SiteModule\Site;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\SiteModule\Site\Event\CreateSite;
use Visiosoft\SiteModule\Site\Event\DeleteSite;
use Visiosoft\SiteModule\Site\Event\SuspendSite;

class SiteRepository extends EntryRepository implements SiteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SiteModel
     */
    protected $model;

    /**
     * Create a new SiteRepository instance.
     *
     * @param SiteModel $model
     */
    public function __construct(SiteModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $subdomain
     * @return mixed
     */
    public function findBySubdomain($subdomain)
    {
        if (!is_null($sites = $this->newQuery()->where('subdomain_name', $subdomain)->get())) {
            return $sites->first();
        }
        return null;
    }

    /**
     * @param $subdomain
     * @param $password
     * @param UserModel $user
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Model
     */
    public function createSite($subdomain, $password, UserModel $user, $subscription)
    {
        $siteParams = [
            'subdomain_name' => $subdomain,
            'assign' => $user->getId(),
            'password' => $password,
        ];
        $newSite = event(new CreateSite($siteParams));
        if (array_first($newSite) !== true) {
            return null;
        } else {
            return $this->newQuery()->create([
                'subdomain_name' => $subdomain,
                'assign_id' => $user->getId(),
                'password' => $password,
            ]);
        }
    }

    public function suspend($id)
    {
        if (!is_null($site = $this->newQuery()->find($id))) {
            $site->update
            ([
                'suspend_at' => date('Y-m-d H:i:s'),
            ]);
            event(new SuspendSite($site, "true"));
        }
    }

    public function unsuspend($id)
    {
        if (!is_null($site = $this->newQuery()->find($id))) {
            $site->update
            ([
                'suspend_at' => null,
            ]);
            event(new SuspendSite($site, "false"));
        }
    }

    public function deleteSite($id)
    {
        if (!is_null($site = $this->newQuery()->find($id))) {
            $site->update
            ([
                'deleted_at' => date('Y-m-d H:i:s'),
            ]);
            if($site->status != "incomplete")
            {
                event(new DeleteSite($site));
            }
        }
    }

    public function findByAssing($user_id)
    {
        return $this->newQuery()
            ->where('assign_id', $user_id)->get();
    }

    public function editDomain($domain)
    {
        $domain = str_replace('http://', '', $domain);
        $domain = str_replace('https://', '', $domain);
        $domain = str_replace('www.', '', $domain);

        return $domain;
    }
}
