<?php namespace Visiosoft\SiteModule\Site\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class CompletedSiteCreate extends Notification implements ShouldQueue
{

    use Queueable;

    public $site;

    public function __construct($site)
    {
        $this->site = $site;
    }

    public function via()
    {
        return ['mail'];
    }

    public function toMail()
    {
        $site = $this->site;
        $user = $this->site->assign;
        return (new MailMessage())
            ->view('visiosoft.theme.base::notifications.email')
            ->subject(trans('visiosoft.module.site::message.newSiteNotification.subject'))
            ->line(trans('visiosoft.module.site::message.newSiteNotification.line1',
                ['url' => "<a target='_blank' href='https://" . $site->subdomain_name . ".openclassify.com'>https://" . $site->subdomain_name . ".openclassify.com</a>"]))
            ->line("<h3>" . trans('visiosoft.module.site::message.newSiteNotification.line2') . "</h3>")
            ->line(trans('visiosoft.module.site::message.newSiteNotification.line3', [
                'email' => $user->email
            ]))
            ->line(trans('visiosoft.module.site::message.newSiteNotification.line4', [
                'password' => $site->password
            ]))
            ->salutation(trans('visiosoft.module.site::message.notification.salutation'));
    }
}
