<?php namespace Visiosoft\SiteModule\Site\AddAddonForm;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;


class AddAddonFormHandler
{
    public function handle(
        AddAddonFormBuilder $builder,
        SiteRepositoryInterface $site,
        AdvRepositoryInterface $advRepository,
        AddonRepositoryInterface $addon
    )
    {

        if (!$builder->canSave()) {
            return;
        }

        $parameters = $builder->getPostData();

        if ($site = $site->find($parameters['subdomain'])) {
            if ($adv = $advRepository->find($parameters['addon'])) {
                event(new AddAddonSite($site, $adv));
                $addon->create([
                    'subdomain' => $site,
                    'addon' => str_replace('_', '-', $adv->slug)
                ]);
            }
        }
    }
}
