<?php namespace Visiosoft\SiteModule\Addon;

use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use function Sodium\add;

class AddonRepository extends EntryRepository implements AddonRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AddonModel
     */
    protected $model;

    /**
     * Create a new AddonRepository instance.
     *
     * @param AddonModel $model
     */
    public function __construct(AddonModel $model)
    {
        $this->model = $model;
    }

    public function getAddonsBySite($subdomain_id_list, $paymentFilter = null)
    {
        $addons = $this->newQuery()
            ->whereIn('subdomain_id', $subdomain_id_list);
        if (!is_null($paymentFilter)) {
            $addons = $addons->where('payment', true);
        }
        return $addons->get();
    }
}
