<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CheckCompletedAddonInstall;
use Visiosoft\SiteModule\Site\Event\installedAddon;

class AddonsController extends ResourceController
{

    private $addon;
    private $ad;
    private $site;
    private $cf;

    public function __construct(
        AddonRepositoryInterface $addon,
        CustomFieldRepositoryInterface $cf,
        AdvRepositoryInterface $ad,
        SiteRepositoryInterface $site)
    {
        $this->addon = $addon;
        $this->ad = $ad;
        $this->site = $site;
        $this->cf = $cf;
    }

    public function AddCart()
    {
        $request = request()->all();

        $site = $this->site->find($request['site']);
        $addon_detail = $this->ad->find($request['addon']);

        $addon_slug = $this->cf->getAdValueByCustomFieldSlug('addon_composer_name', $request['addon']);


        if ($site and $site->status == "completed" and $addon_slug) {
            $is_addon_installed = $this->addon
                ->newQuery()
                ->where('installed', true)
                ->where('addon', $addon_slug)
                ->where('subdomain_id', $site->id)->first();
            if (is_null($is_addon_installed)) {
                $addonRecord = $this->addon->create([
                    'subdomain' => $site,
                    'addon' => $addon_slug,
                    'installed' => false,
                ]);
                $addonRecord->name = $addon_detail->name;
                $addonRecord->price = $addon_detail->price;
                $addonRecord->currency = $addon_detail->currency;
                $cart = $this->dispatch(new GetCart());
                $cart->add($addonRecord, 1, $site->subdomain_name . "." . $site->type);
                return redirect('cart');
            }
        }
        return back();
    }

    public function checkAddon()
    {
        $pending_addons = $this->addon->newQuery()->where('installed', 'pending')->get();

        foreach ($pending_addons as $addon) {
            if($addon->subdomain)
            {
                $result = event(new CheckCompletedAddonInstall($addon->subdomain, $addon->addon));

                if (!is_null($result) and isset($result[0]['result']) and $result[0]['result'] == "SUCCESS") {
                    event(new installedAddon($addon->subdomain, $addon->addon));

                    $addon->update(['installed' => true]);
                }
            }
        }
    }
}
