<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use EmailChecker\Laravel\EmailCheckerFacade;
use EmailChecker\Laravel\EmailCheckerServiceProvider;
use Visiosoft\NotificationsModule\Listeners\CompletedInstallationSiteAdminMail;
use Visiosoft\NotificationsModule\Listeners\FreeTrialSubscriptionCreatedAdminMail;
use Visiosoft\NotificationsModule\Listeners\FreeTrialSubscriptionCreatedMail;
use Visiosoft\SiteModule\AddonTrial\Contract\AddonTrialRepositoryInterface;
use Visiosoft\SiteModule\AddonTrial\AddonTrialRepository;
use Anomaly\Streams\Platform\Model\Site\SiteAddonTrialEntryModel;
use Visiosoft\SiteModule\AddonTrial\AddonTrialModel;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\SiteModule\Console\CheckActivateSites;
use Visiosoft\SiteModule\Console\CheckInstalledAddon;
use Visiosoft\SiteModule\Console\CheckRefreshSites;
use Visiosoft\SiteModule\Console\SendGuide;
use Visiosoft\SiteModule\Listeners\AddTrialButton;
use Visiosoft\SiteModule\Site\Event\subscriptions\FreeTrialSubscriptionCreatedEvent;
use Visiosoft\SiteModule\StoreDomain\Contract\StoreDomainRepositoryInterface;
use Visiosoft\SiteModule\StoreDomain\StoreDomainRepository;
use Anomaly\Streams\Platform\Model\Site\SiteStoreDomainEntryModel;
use Visiosoft\SiteModule\StoreDomain\StoreDomainModel;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Bundle\BundleRepository;
use Anomaly\Streams\Platform\Model\Site\SiteBundlesEntryModel;
use Visiosoft\SiteModule\Bundle\BundleModel;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Addon\AddonRepository;
use Anomaly\Streams\Platform\Model\Site\SiteAddonEntryModel;
use Visiosoft\SiteModule\Addon\AddonModel;
use Visiosoft\SiteModule\Addon\Listener\PaymentSuccessAddon;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Domain\DomainRepository;
use Anomaly\Streams\Platform\Model\Site\SiteDomainEntryModel;
use Visiosoft\SiteModule\Domain\DomainModel;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Listener\CreatedNewSubscriptionForActivatedUser;
use Visiosoft\SiteModule\Site\Listener\SubscriptionDeleted;
use Visiosoft\SiteModule\Site\Listener\SubscriptionExpired;
use Visiosoft\SiteModule\Site\Listener\SubscriptionSuspended;
use Visiosoft\SiteModule\Site\Listener\SubscriptionUnSuspended;
use Visiosoft\SiteModule\Site\Listener\webhook\CreatedNewSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\DeletedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\FailedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\RenewedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\SuspendedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\UpgradeSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\SiteRepository;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;
use Visiosoft\SiteModule\Site\SiteModel;
use Visiosoft\SubscriptionsModule\Subscription\Event\DeletedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\ExpiredSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreatedForActivatedUser;
use Visiosoft\SubscriptionsModule\Subscription\Event\SuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\UnSuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\UpgradeSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionCreatedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionDeletedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionFailedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionSuspendForWebhook;

class SiteModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        SiteModulePlugin::class
    ];

    protected $commands = [
        CheckRefreshSites::class,
        SendGuide::class,
        CheckActivateSites::class,
        CheckInstalledAddon::class,
    ];

    protected $schedules = [
        '* * * * *' => [
            CheckRefreshSites::class,
            SendGuide::class,
            CheckActivateSites::class,
            CheckInstalledAddon::class,
        ],
    ];

    protected $routes = [
        'admin/site/addon_trial' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonTrialController@index',
        'admin/site/addon_trial/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonTrialController@create',
        'admin/site/addon_trial/edit/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonTrialController@edit',
        'admin/site/store_domain' => 'Visiosoft\SiteModule\Http\Controller\Admin\StoreDomainController@index',
        'admin/site/store_domain/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\StoreDomainController@create',

        'admin/site/bundles' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@index',
        'admin/site/bundles/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@create',
        'admin/site/bundles/edit/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\BundlesController@edit',
        'bundle/{id}' => 'Visiosoft\SiteModule\Http\Controller\BundlesController@detail',
        'add-cart/bundle' => [
            'as' => 'visiosoft.module.site::bundle.add_cart',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\BundlesController@addCart',
        ],

        'admin/site/addon' => [
            'as' => 'visiosoft.module.site::admin.addon.list',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@index',
        ],
        'admin/addon/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@checkAddon',
        'admin/site/addon/installation/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@AddonInstall',
        'admin/site/domain' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@index',
        'admin/site/domain/create' => [
            'as' => 'visiosoft.module.site::admin.domain.create',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@create',
        ],
        'admin/site' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@index',
        'admin/site/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@create',
        'admin/site/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@check',
        'admin/site/{site_id}/send/{template_slug}' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@sendEmail',
        'admin/site/add-addon' => [
            'as' => 'visiosoft.module.site::admin.add.addon',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addAddon'
        ],
        'profile/mysites/add-domain/{id}' => [
            'as' => 'add-domain',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@addDomain',
        ],
        'site/create' => [
            'as' => 'visiosoft.module.site::create-site',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@create',
        ],
        'my-sites' => [
            'as' => 'visiosoft.module.site::my-sites',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@index'
        ],

        'ajax/trial-register' => [
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@registerUser',
        ],
        'ajax/user-verification' => [
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@userVerification',
        ],
        'ajax/trial-register-validate' => 'Visiosoft\SiteModule\Http\Controller\SiteController@registerValidate',
        'ajax/resend-verify-sms/{id}' => 'Visiosoft\SiteModule\Http\Controller\SiteController@reSendVerifySms',
        'ajax/get-site-status/{siteId}' => 'Visiosoft\SiteModule\Http\Controller\SiteController@getSiteStatus',
        'addon/addCart' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@addCart',
        'admin/ajax/getAddonsForSite/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@getAddonListForSite',
        'admin/site/complete-on-manuel/{id}' => [
            'as' => 'visiosoft.module.site::admin.complete.on.manuel',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@completeOnManuel',
        ],
        'installation-started' => [
            'as' => 'visiosoft.module.site::installation.started',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@installationStarted',
        ],

        //Cron
        'cron/pendingSites' => 'Visiosoft\SiteModule\Http\Controller\SiteController@activateSites',
        'cron/cronGuide' => 'Visiosoft\SiteModule\Http\Controller\SiteController@cronGuide',
        'cron/checkAddon' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@checkAddon',
        'cron/auto-refresh' => 'Visiosoft\SiteModule\Http\Controller\SiteController@autorefresh',
        'cron/check-site-status' => 'Visiosoft\SiteModule\Http\Controller\SiteController@checkSiteStatus',


        //Ajax
        'admin/site/ajax/search-addon' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@searchAddon',
        'admin/site/choose-plan/{id}' => [
            'as' => 'visiosoft.module.site::choose_plan',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SubscriptionController@choosePlan'
        ],

        'admin/site/change-plan/{id}/{plan_id}' => [
            'as' => 'visiosoft.module.site::change_plan',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SubscriptionController@changePlan'
        ],

        'admin/site/add-bundle' => [
            'as' => 'visiosoft.module.site::admin.add.bundle',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addBundle'
        ],

        'create-store-domain' => 'Visiosoft\SiteModule\Http\Controller\StoreDomainController@createStoreSubDomianAPI',
        'admin/site/add-ssl' => [
            'as' => 'visiosoft.module.site::admin.add.ssl',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addSSL'
        ],

        'api/site/try/{subdomain_name}/{addon_namespace}/{redirect_url}' => [
            'as' => 'visiosoft.module.site::api.site.try',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@tryAddon'
        ],
        'cron/site/remove-expired-addons' => [
            'as' => 'visiosoft.module.site::site.remove.expired.addons',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@removeExpiredAddons'
        ],
        'api/get-sites-by-assign' => [
            'as' => 'visiosoft.module.site::getSitesByAssign',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@getSitesByAuthUser'
        ],
        'api/add-addon' => 'Visiosoft\SiteModule\Http\Controller\SiteController@addAddon',
        'api/site-detail' => 'Visiosoft\SiteModule\Http\Controller\ApiController@detail',
        'api/add-domain' => 'Visiosoft\SiteModule\Http\Controller\ApiController@addDomain',
        'api/list-domain' => 'Visiosoft\SiteModule\Http\Controller\ApiController@listDomain',
        'api/add-domain-ssl' => 'Visiosoft\SiteModule\Http\Controller\ApiController@addDomainSSL',
    ];

    protected $listeners = [
        SubscriptionCreatedForWebhook::class => [
            CreatedNewSubscriptionForWebhook::class
        ],
        SubscriptionRenewedForWebhook::class => [
            RenewedSubscriptionForWebhook::class
        ],
        SubscriptionSuspendForWebhook::class => [
            SuspendedSubscriptionForWebhook::class
        ],
        SubscriptionFailedForWebhook::class => [
            FailedSubscriptionForWebhook::class
        ],
        SubscriptionDeletedForWebhook::class => [
            DeletedSubscriptionForWebhook::class,
        ],
        SuspendedSubscription::class => [
            SubscriptionSuspended::class
        ],
        UnSuspendedSubscription::class => [
            SubscriptionUnSuspended::class
        ],
        DeletedSubscription::class => [
            SubscriptionDeleted::class,
        ],
        ExpiredSubscription::class => [
            SubscriptionExpired::class
        ],

//        SubscriptionEnabled::class => [
//            UnSuspendSubscription::class
//        ],
//        SubscriptionDeleted::class => [
//            DeletedSubscription::class
//        ],
        PaymentSuccess::class => [
            PaymentSuccessAddon::class,
            \Visiosoft\SiteModule\Bundle\Listener\PaymentSuccess::class
        ],
        SubscriptionCreatedForActivatedUser::class => [
            CreatedNewSubscriptionForActivatedUser::class,
        ],
        FreeTrialSubscriptionCreatedEvent::class => [
            FreeTrialSubscriptionCreatedMail::class,
            FreeTrialSubscriptionCreatedAdminMail::class,
        ],
        UpgradeSubscription::class => [
            UpgradeSubscriptionForWebhook::class,
        ],
        OrderApproved::class => [
            \Visiosoft\SiteModule\Bundle\Listener\OrderApproved::class,
            \Visiosoft\SiteModule\Addon\Listener\OrderApproveListener::class,
        ],
    ];

    protected $providers = [
        EmailCheckerServiceProvider::class
    ];

    protected $aliases = [
        'EmailChecker' => EmailCheckerFacade::class
    ];

    protected $bindings = [
        SiteAddonTrialEntryModel::class => AddonTrialModel::class,
        SiteStoreDomainEntryModel::class => StoreDomainModel::class,
        SiteBundlesEntryModel::class => BundleModel::class,
        SiteAddonEntryModel::class => AddonModel::class,
        SiteDomainEntryModel::class => DomainModel::class,
        SiteSiteEntryModel::class => SiteModel::class,
    ];

    protected $singletons = [
        AddonTrialRepositoryInterface::class => AddonTrialRepository::class,
        StoreDomainRepositoryInterface::class => StoreDomainRepository::class,
        BundleRepositoryInterface::class => BundleRepository::class,
        AddonRepositoryInterface::class => AddonRepository::class,
        DomainRepositoryInterface::class => DomainRepository::class,
        SiteRepositoryInterface::class => SiteRepository::class,
    ];
}
