<?php namespace Visiosoft\SiteModule\Site;

use Visiosoft\SiteModule\Site\Contract\SiteInterface;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;
use Visiosoft\SiteModule\Site\Event\ReinstallSite;

class SiteModel extends SiteSiteEntryModel implements SiteInterface
{
    protected $ttl = false;

    /**
     * @return string
     * Get Site Url
     */
    public function getUrl()
    {
        return $this->subdomain_name . "." . $this->type;
    }

    /**
     * @param $status
     * Change Site Status
     */
    public function changeStatus($status, $params = [])
    {
        $this->update(array_merge(['status' => $status], $params));
    }

    /**
     * @param $message
     * @return mixed|void
     * Update Error Message
     */
    public function updateErrorMsg($message)
    {
        $this->update([
            'message' => $message,
            'status' => "error",
        ]);
    }

    /**
     * @param $id
     * Set Subscription ID
     */
    public function setSubscription($id)
    {
        $this->setAttribute('subscription_id', $id);
        $this->save();
    }

    /**
     * Suspend Site
     */
    public function suspend()
    {
        $this->update(['suspend_at' => date('Y-m-d H:i:s')]);
    }

    /**
     * Unsuspend Site
     */
    public function unsuspend()
    {
        $this->update(['suspend_at' => null, 'deleted_at' => null]);
    }

    /**
     * Update Site
     */
    public function updatedSite()
    {
        $this->update(['update_at' => date('Y-m-d H:i:s')]);
    }

    /**
     * @return mixed|void
     * Terminate Site
     */
    public function terminate()
    {
        $this->update([
            'deletedCwp' => date('Y-m-d H:i:s'),
            'delete_status' => 'completed'
        ]);
    }

    public function getUser()
    {
        return $this->assign;
    }

    public function getPassword()
    {
        return $this->password;
    }

    public function autoRefresh()
    {
        return $this->auto_refresh;
    }

    public function reinstall()
    {
        event(new ReinstallSite($this));
    }

    public function username()
    {
        return $this->subdomain_name;
    }

    public function type()
    {
        return $this->type;
    }

    public function getServer()
    {
        return $this->node;
    }

    public function getLocale()
    {
        return $this->locale;
    }

    public function getToken()
    {
        return $this->api_token;
    }

    public function generateSubdomainForDuplicates($newSubdomain)
    {
        return $this->update([
            'subdomain_name' => $newSubdomain
        ]);
    }

    public function updateDeleteStatus($status)
    {
        return $this->update([
            'delete_status' => $status
        ]);
    }

    public function getSubscriptionID()
    {
        return $this->subscription_id;
    }
}
