<?php

return [
    'demo_domains' => [
        'type' => 'anomaly.field_type.tags',
        'config' => [
            "default_value" => ['openclassify.com', 'revisio.app', 'ocify.co'],
        ],
    ],
    'default_domain' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'ocify.co',
        ],
    ],
    'default_node_server' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            "handler" => "Visiosoft\SiteModule\Site\Handler\NodeList@handle",
            'default_value' => "ocifydemo",
        ],
    ],
    'send_guide_after_days' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 1,
            'min' => 1,
        ],
    ],
    'trial_period'  => [
        'type'   => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 1,
        ],
    ],
    'default_app' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\SiteModule\Site\SiteModel::class,
            'mode' => 'lookup'
        ]
    ],
    'sub_installation' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false
        ]
    ],
    'verify_period'  => [
        'type'   => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 30,
        ],
    ],
    'documentation_link' => [
        'type' => 'anomaly.field_type.url',
    ],
    'tutorial_link'  => [
        'type'   => 'anomaly.field_type.url',
    ],
    'extend_day'  => [
        'type'   => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 30,
        ],
    ],
];
