<?php namespace Visiosoft\SiteModule\Traits;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Support\Facades\DB;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;

trait PaymentBundle
{
    public function installBundleAddons($bundle,$site)
    {
        $cf = app(CustomFieldRepositoryInterface::class);
        $addon = app(AddonRepositoryInterface::class);
        $message = app(MessageBag::class);

        $addons = DB::table('site_bundles_addons')
            ->where('entry_id', $bundle->id)
            ->get()
            ->pluck('related_id')
            ->all();

        if (count($addons)) {
            $install_addons = array();
            foreach ($addons as $item) {
                if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $item)) {

                    $addon_array = explode('-', $is_addon);
                    $install_addons[] = ["type" => $addon_array[1], "name" => $addon_array[0]];

                    $addon->create([
                        'subdomain' => $site,
                        'addon' => $is_addon,
                        'payment' => false,
                        'installed' => 'pending',
                        'entry_id' => $item,
                        'entry_type' => 'Visiosoft\AdvsModule\Adv\AdvModel'
                    ]);

                    $message->success(trans('visiosoft.module.site::message.addAddon'));
                } else {
                    $message->error(trans('visiosoft.module.site::message.error_addon_slug'));
                }
            }
            if (count($install_addons)) {
                event(new AddMultipleAddonSite($site, $install_addons));
            }
        }
    }
}