<?php namespace Visiosoft\SiteModule\Site\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ExtendSite implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $site;
    public $days;

    public $tries = 3;

    public function __construct($site, $days)
    {
        $this->site = $site;
        $this->days = $days;
    }

    public function retryUntil()
    {
        return now()->addMinutes(10);
    }

    public function handle()
    {
        event(new \Visiosoft\SiteModule\Site\Event\ExtendSite($this->site, $this->days));

    }
}
