<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\AddAddonForm\AddAddonFormBuilder;
use Visiosoft\SiteModule\Site\AddBundleForm\AddBundleFormBuilder;
use Visiosoft\SiteModule\Site\AddSslForm\AddSslFormBuilder;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\BuildSubSite;
use Visiosoft\SiteModule\Site\Event\CreateSiteOnManuel;
use Visiosoft\SiteModule\Site\Event\SendEmailTemplate;
use Visiosoft\SiteModule\Site\Form\SiteFormBuilder;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SiteController extends AdminController
{
    private $site;
    private $bundleRepository;
    private $customFieldRepository;

    public function __construct(
        SiteRepositoryInterface $site,
        BundleRepositoryInterface $bundleRepository,
        CustomFieldRepositoryInterface $customFieldRepository
    )
    {
        $this->site = $site;
        $this->bundleRepository = $bundleRepository;
        $this->customFieldRepository = $customFieldRepository;
        parent::__construct();
    }

    public function index(SiteTableBuilder $table)
    {
        return $table->render();
    }

    public function choose(TemplateRepositoryInterface $templateRepository, $id)
    {
        return $this->view->make('module::admin/site/choose', ['templates' => $templateRepository->all(), 'id' => $id]);
    }

    public function sendEmail($id, $slug)
    {
        try {
            $site = $this->site->find($id);

            event(new SendEmailTemplate($site, $slug));

            $this->messages->success('Email send successfully!');
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect('admin/site');
    }

    public function create(SiteFormBuilder $form)
    {
        return $form->render();
    }

    public function addAddon(AddAddonFormBuilder $form)
    {
        return $form->render();
    }

    public function addSSL(AddSslFormBuilder $form)
    {
        return $form->render();
    }

    public function addBundle(AddBundleFormBuilder $form)
    {
        return $form->render();
    }

    public function completeOnManuel($id)
    {
        //Check Site
        if ($site = $this->site->find($id)
            and $site->status == "incomplete") {

            if ($app_site = $site->app) {

                $response = array_first(event(new BuildSubSite($site)));
            } else {
                $response = array_first(event(new BuildSite($site)));
            }


            if (!$response['status']) {
                $site->updateErrorMsg($response['message']);
                $this->messages->error([$response['message']]);
            } else {
                $site->changeStatus('pending');

                $response_subscription = array_first(event(new CreateSiteOnManuel($site)));

                $this->messages->success(trans('visiosoft.module.site::message.started_on_manual'));

                if ($response_subscription) {
                    $site->setSubscription($response_subscription->id);
                    $this->messages->success(trans('visiosoft.module.site::message.started_subscription', ['id' => $response_subscription->id]));
                } else {
                    $this->messages->error(trans('visiosoft.module.site::message.failed_start_subscription'));
                }
            }
        }
        return back();
    }

    public function edit(SiteFormBuilder $builder, $id)
    {
        return $builder->render($id);
    }
}
