<?php namespace Visiosoft\SiteModule\Domain;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class DomainRepository extends EntryRepository implements DomainRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DomainModel
     */
    protected $model;

    /**
     * Create a new DomainRepository instance.
     *
     * @param DomainModel $model
     */
    public function __construct(DomainModel $model)
    {
        $this->model = $model;
    }

    public function getDomainsBySite($subdomain_id_list)
    {
        return $this->newQuery()->whereIn('subdomain_id', $subdomain_id_list)->get();
    }

    public function findDomain($domain)
    {
        return $this->newQuery()->where('domain', $domain)->first();
    }

    public function getBySite($id)
    {
        return $this->newQuery()->where('subdomain_id', $id)->get();
    }
}
