<?php namespace Visiosoft\CloudsiteModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Http\Request;
use Visiosoft\CloudsiteModule\Domain\DomainModel;
use Visiosoft\CloudsiteModule\Domain\Form\DomainFormBuilder;
use Visiosoft\CloudsiteModule\Domain\Table\DomainTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CloudsiteModule\Site\Event\AddDomainSite;
use Visiosoft\CloudsiteModule\Site\SiteModel;

class DomainsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param DomainTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DomainTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param DomainFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(
        DomainFormBuilder $form,
        Request $request,
        Dispatcher $events,
        SettingRepositoryInterface $settings,
        DomainModel $domainModel,
        SiteModel $siteModel
    )
    {
        $form->setActions(['save_create']);
        if ($request->action == "save_create") {
            $site = $siteModel->find($request->subdomains_item);

            $domainModel->create(['subdomains_item_id' => $site->id, 'domain' => $request->domain]);

            $response['domain'] = $request->domain;
            $response['subdomain'] = $site->subdomain;
            $events->dispatch(new AddDomainSite($response, $settings));
        }

        return $form->render();
    }

}
