<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\subscriptions\CreateSubscriptionForChangeSitePlan;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;

class SubscriptionController extends AdminController
{
    protected $repository;

    public function __construct(SiteRepositoryInterface $repository)
    {
        $this->repository = $repository;
        parent::__construct();
    }

    public function choosePlan(PlanRepositoryInterface $planRepository, $id)
    {
        return $this->view->make('visiosoft.module.site::admin/subscriptions/choose', ['plans' => $planRepository->all(), 'id' => $id]);
    }

    public function changePlan($id, $plan_id)
    {
        if ($site = $this->repository->find($id) and $user = $site->getUser()) {
            event(new CreateSubscriptionForChangeSitePlan($user, $plan_id, $site));
        }
        return redirect('admin/site');
    }
}
