<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\SiteModule\Site\SiteModel;

class VisiosoftModuleSiteCreateBundlesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'bundles',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'addons' => [
            'type' => 'anomaly.field_type.multiple',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class,
            ]
        ],
    ];

    protected $assignments = [
        'name' => [
            'required' => true,
        ],
        'addons' => [
            'required' => true,
        ],
    ];

}
