<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Notifications\SiteModuleNotificationsTemplateSeeder;

class SiteModuleSeeder extends Seeder
{
    /**
     * Run the seeder.
     */
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => str_slug(trans('visiosoft.module.site::field.addon_composer_name'), '_')],
                ['name' => trans('visiosoft.module.site::field.addon_composer_name'), 'type' => 'text']
            );
        }

        //Notifications Templates
        $this->call(SiteModuleNotificationsTemplateSeeder::class);
    }
}