<?php namespace Visiosoft\SiteModule\Domain\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Domain\Event\DeletedDomain;
use Visiosoft\SiteModule\Domain\Event\DeleteDomain;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;


class Delete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, DomainRepositoryInterface $domain, MessageBag $message, array $selected)
    {
        foreach ($selected as $id) {
            if ($domain = $domain->find($id)) {
                if ($site = $site->findWithTrashed($domain->subdomain_id)) {
                    $response = array_first(event(new DeleteDomain($site, $domain)));
                    $domain->delete();
                    event(new DeletedDomain($site, $domain));

                    if ($response['status']) {
                        $message->success(trans('streams::message.delete_success'));
                    } else {
                        $message->error([$domain->domain."-".$response['message']]);
                    }
                }
            }
        }
    }
}