<?php namespace Visiosoft\SiteModule\Site\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\ProfileModule\Events\UserActivatedBySmsEvent;

class UserActivatedBySms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $user;

    public $tries = 3;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function retryUntil()
    {
        return now()->addMinutes(10);
    }

    public function handle()
    {
        event(new UserActivatedBySmsEvent($this->user));
    }
}
