<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;


class SoftDelete extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, array $selected)
    {
        foreach ($selected as $id) {
            $site->softdeleteSite($id);
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.deleted', ['count' => count($selected)]));
        }
    }
}