<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Addon\Table\AddonTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SiteModule\Site\Event\installAddon;
use Visiosoft\SiteModule\Site\SiteModel;

class AddonController extends AdminController
{

    private $addon;

    public function __construct(AddonRepositoryInterface $addon)
    {
        $this->addon = $addon;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param AddonTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AddonTableBuilder $table)
    {
        $table->setColumns([
            'subdomain', 'addon', 'payment' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->payment) {
                        return "<div class='tag tag-success'><i class='fa fa-check'></i></div>";
                    } else {
                        return "<div class='tag tag-danger'><i class='fa fa-lg fa-times'></i></div>";
                    }
                }
            ],
            'installed' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->installed == 1) {
                        return "<div class='tag tag-success'><i class='fa fa-check'></i></div>";
                    } elseif ($entry->installed == "pending") {
                        return "<div class='tag tag-info'><i class='fa fa-lg fa-clock-o'></i></div>";
                    } else {
                        return "<div class='tag tag-danger'><i class='fa fa-lg fa-times'></i></div>";
                    }
                }
            ],
            'actions' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->installed === false) {
                        return "<a href='/admin/site/addon/installation/" . $entry->id . "' class='btn btn-xs btn-info w-100 fa fa-inbox'> "
                            . trans('visiosoft.module.site::button.install') . "</a>";
                    }
                }
            ],
        ]);
        return $table->render();
    }

    public function AddonInstall(AddonRepositoryInterface $addon, SiteModel $site, $id)
    {
        if (!is_null($addon = $addon->find($id))) {
            if (!is_null($site = $site->find($addon->subdomain_id))) {
                event(new installAddon($site, $addon->addon));
                $addon->payment = true;
                $addon->save();

                $this->messages->success(trans('streams::installer.installing', ['installing' => $addon->addon]));
                return $this->redirect->to('/admin/site/addon');
            }
        }
    }

    public function getAddonListForSite($id)
    {
        $addons = $this->addon->getAddonsBySite([$id])->pluck('entry_id');

        return response()->json(['addons' => $addons]);
    }
}
