<?php namespace Visiosoft\SiteModule\Domain\Form;


use Visiosoft\SiteModule\Domain\Event\CreateDomain;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class DomainFormHandler
{
    public function handle(DomainFormBuilder $builder, SiteRepositoryInterface $site)
    {

        if (!$builder->canSave()) {
            return;
        }

        $post_data = $builder->getPostData();

        $domain = $site->editDomain($post_data['domain']);

        $site = $site->find($post_data['subdomain']);
        $newSite = event(new CreateDomain($site, $domain));
        if (array_first($newSite) !== true) {
            return redirect('/admin/site/domain');
        } else {
            $builder->saveForm();

            $builder->getFormEntry();
        }
    }
}
