var vstore = {};

$(() => {
    $('.resend-verify').on('click', function () {
        crudAjax({}, '/ajax/resend-verify-sms/'+vstore.pid, 'GET', function (r) {
            if (r.status) {
                timerResend();
            }
        },true);
    });

    function limitText(field, maxChar) {
        let ref = $(field),
            val = ref.val();
        if (val.length >= maxChar) {
            ref.val(function () {
                return val.substr(0, maxChar);
            });
        }
    }

    $(function () {
        $('.digit-input').each(function () {
            $(this).attr('maxlength', 1);
            $(this).on('keyup', function (e) {
                limitText(this, 1);
                let filled = true;
                $('.digit-input').each(function (index, element) {
                    let ref = $(element),
                        val = ref.val()
                    if (val.length === 0) {
                        filled = false;
                        $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                    }
                })
                if (filled) {
                    $('.activation-action-btn').removeClass('disabled').prop('disabled', false);
                }
                let parent = $($(this).parent());
                if (e.keyCode === 8 || e.keyCode === 37) {
                    let prev = parent.find('input#' + $(this).data('previous'));
                    if (prev.length) {
                        $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                        $(prev).select();
                    }
                } else if (
                    (e.keyCode >= 48 && e.keyCode <= 57)
                    || (e.keyCode >= 65 && e.keyCode <= 90)
                    || (e.keyCode >= 96 && e.keyCode <= 105)
                    || e.keyCode === 39) {
                    let next = parent.find('input#' + $(this).data('next'));
                    if (next.length > 0) {
                        $(next).select();
                    }
                }
            });
        });
        $(document).on('click', '.next_third_step', function () {
            $('#freeTrialModal .modal-dialog').addClass('modal-lg')
        });
    })
    let country = document.getElementById('default-phone-country')
        ? document.getElementById('default-phone-country').innerText : null;
    let phone = document.getElementById('phone');

    const iti = intlTelInput(phone, {
        class: "phone",
        initialCountry: "auto",
        formatOnDisplay: true,
        nationalMode: true,
        hiddenInput: phone.name,
        utilsScript: 'utils/utils.js',
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = country ? country : (resp && resp.country) ? resp.country : "";
                success(countryCode);
            })
        }
    });

    addMask(iti, phone);
    $(phone).on("countrychange", function (event) {
        iti.setNumber("");
        addMask(iti, phone);
    });

    function addMask(iti, phone) {
        let selectedCountryData = iti.getSelectedCountryData();
        let newPlaceholder = intlTelInputUtils.getExampleNumber(selectedCountryData.iso2, true, intlTelInputUtils.numberFormat.INTERNATIONAL);
        $(phone).inputmask({mask: newPlaceholder.replace(/[0-9+]/ig, '9'), keepStatic: false});
    }

    function controlNumber(phone) {
        var iti = intlTelInput(phone, {
            hiddenInput: phone.getAttribute('name'),
            class: "phone",
            initialCountry: "auto",
            geoIpLookup: function (success, failure) {
                $.get("https://ipinfo.io", function () {
                }, "jsonp").always(function (resp) {
                    var countryCode = (resp && resp.country) ? resp.country : "";
                    success(countryCode);
                })
            }
        })
        return iti.isValidNumber();
    }

    function validateEmail($email) {
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        return emailReg.test($email);
    }

    $('#freeTrialModal .close').on('click', function () {
        $('#freeTrialModal .modal-dialog').removeClass('modal-lg');
        $('#freeTrialModal .error-message').html('');
        $('#freeTrialModal .one_step').removeClass('d-none');
        $('#freeTrialModal .step').addClass('d-none');
        $('#freeTrialModal').find('.form-error').removeClass('form-error');
        $('#ocTrialForm').trigger('reset');
    });

    $('.try-demo-openclassify').on('click', function () {
        $('#freetrialForm').modal('toggle');
    });

    let paddle_id;
    $('.try-demo-ocify').on('click', function (e) {
        paddle_id = $(e.target).data('id');
        $('#freeTrialModal').modal('toggle');
    });
    $('#freeTrialModal input[name="subdomain"]').on('keyup', () => {
        if ($('#freeTrialModal input[name="subdomain"]').val().length > 8) {
            $('.subdomain-max-length').removeClass('hidden');
        } else {
            $('.subdomain-max-length').addClass('hidden');
        }
    })
    $('.next_second_step').on('click', function () {
        /* Trial Form Validate Req */
        let fieldErrors = $('.formErrors.field');
        let termOfUseErrors = $('.formErrors.term_of_use_error');
        let subdomain = $('#freeTrialModal input[name="subdomain"]').val();
        let domain = $('#freeTrialModal select[name="domain"]').val();
        let email = $('#freeTrialModal input[name="email"]').val();
        let name_surname = $('#freeTrialModal input[name="name_surname"]').val();
        let phoneNumber = iti.getNumber();
        $('#freeTrialModal .form-control').focus(function () {
            $(this).removeClass('form-error');
        });
        if ($('#freeTrialModal input[name="term_of_use"]:checked').val() !== 'true') {
            termOfUseErrors.html("<p class='mb-0'><i class='fa fa-exclamation-triangle'></i>" + errorList['term_of_use'] + "</p>");
        } else {
            $.ajax({
                type: 'POST',
                data: {
                    storename: subdomain,
                    domain: domain,
                    email: email,
                    name_surname: name_surname,
                    phone: phoneNumber
                },
                url: '/ajax/trial-register-validate',
                beforeSend: function () {
                    fieldErrors.html('');
                    termOfUseErrors.html('');
                    $('#freeTrialModal .error-message').html('');
                    $('#freeTrialModal').find('.form-error').removeClass('form-error');
                }, success: function (response) {
                    if (!response.status) {
                        $.each(response.errors, (key, msg) => {
                            fieldErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + msg + "</p>");
                        })
                    } else {
                        $('#freeTrialModal .modal-dialog').addClass('modal-lg');
                        $('.one_step, .two_step').toggleClass('d-none');
                    }
                }, error: function (reject) {
                    $.each($.parseJSON(reject.responseText).errors, (key, msg) => {
                        key = (key === 'storename' ? 'subdomain' : key);
                        $('#freeTrialModal input[name="' + key + '"]').addClass('form-error');
                        $('#freeTrialModal .error-' + key).html(msg);
                        $('#freeTrialModal select[name="' + key + '"]').addClass('form-error');
                    });
                }
            })
        }
    });

    $('.next_third_step').on('click', function () {
        $('#freeTrialModal .modal-dialog').addClass('modal-lg');
        $('.two_step, .three_step').toggleClass('d-none');
    });

    let locale = 'en';
    $('.lang_select_area').on('click', function () {
        locale = $(this).parent().find('input').val();
        $('#ocTrialForm').submit();

        $('.three_step, .fourth_step').toggleClass('d-none');
    })
    let registeredUserEmail, storeName;

    //trial form is inside openclassify, ocTrial is inside ocify .
    $("#trialForm").submit(function (e) {
        ///////////////////////////////////////////////////////////////////////////////////////
        // todo: activate yandex metrica later #### important: i disabled it in my localhost ///
        // ym(66363319, 'reachGoal', 'trialFormSubmitted');////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////
        e.preventDefault();
        let email = $(this).find('input[name="email"]').val();
        let name = $(this).find('input[name="name_surname"]').val();
        let storename = $("input[name='storename']").val().replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');
        /*** Validation Email */
        if (validateEmail(email)) {
            var passthrough = {
                'name_surname': name,
                "email": email,
                'storename': storename,
                'locale': locale,
                'noSMS': true
            };
            $.ajax({
                type: 'POST',
                data: passthrough,
                url: '/ajax/trial-register',
                beforeSend: function () {
                    $(".error-warnings").html("");
                    $('#trialForm').find('.submitBtn').prop("disabled", true);
                },
                success: function (c) {
                    if (c.status) {
                        if (c.data.isActive) {
                            Toast.fire(c.message, 'success');
                        } else {
                            $("#created-user-modal").modal('show');
                            $("#created-user-modal").find("button").on("click", () => {
                                $("#created-user-modal").modal('hide');
                            });
                        }
                        $("#freetrialForm").modal('hide');
                    } else {
                        /*** Show Error Message */
                        Object.values(c.responseJSON.errors).forEach(value => {
                            $(".error-warnings").removeClass('d-none').append(`<div><i class='fa fa-times text-danger mr-2'></i>${value[0]}</div>`);
                        });
                    }
                },
                error: function (c) {
                    /*** Show Error Message */
                    Object.values(c.responseJSON.errors).forEach(value => {
                        $(".error-warnings").removeClass('d-none').append(`<div><i class='fa fa-times text-danger mr-2'></i>${value[0]}</div>`);
                    });
                },
                complete: function () {
                    $('#freetrialForm').find('.submitBtn').prop("disabled", false);
                }
            });
        }
    });

    $("#ocTrialForm").submit(function (e) {
        ///////////////////////////////////////////////////////////////////////////////////////
        // todo: activate yandex metrica later #### important: i disabled it in my localhost ///
        // ym(66363319, 'reachGoal', 'trialFormSubmitted');////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////
        e.preventDefault();
        let thisForm = $(this).attr('id');
        let formErrors = $('.formErrors');
        let form = $("#" + thisForm);
        let email = $(this).find('input[name="email"]').val();
        let name = $(this).find('input[name="name_surname"]').val();
        let phone = iti.getNumber();
        phone = phone.substring(1);
        let storename = (thisForm === 'ocTrialForm') ? $("input[name='subdomain']").val() : $("input[name='storename']").val()
        storename = storename.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');
        let theme = $('#freeTrialModal input[name="bundle"]:checked').val();
        /*** Validation Email */
        if (validateEmail(email)) {
            var passthrough = {
                'name_surname': name,
                "email": email,
                'storename': storename,
                'phone': phone,
                'theme': theme,
                'locale': locale,
            };
            $.ajax({
                type: 'POST',
                data: passthrough,
                url: '/ajax/trial-register',
                beforeSend: function () {
                    $('#freetrialForm,  #ocTrialForm').find('.submitBtn').prop("disabled", true);
                    timerResend();
                },
                success: function (c) {
                    formErrors.html("");
                    if (c.status) {
                        vstore.pid = c.vid;
                        registeredUserEmail = c.data.email
                        storeName = c.data.storename
                    } else {
                        /*** Show Error Icon */
                        if (c.type) {
                            $.each(c.type, function (i, t) {
                                if (t === false) {
                                    $('.' + i).removeClass('d-none');
                                    formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                                } else {
                                    if (!$('.' + i).hasClass('d-none')) {
                                        $('.' + i).addClass('d-none');
                                    }
                                }
                            });
                        } else {
                            formErrors.append(`<p><i class='fa fa-exclamation-triangle'></i>${c.message}</p>`);
                        }
                    }
                },
                complete: function () {
                    $('#freetrialForm').find('.submitBtn').prop("disabled", false);
                    $('#freetrialForm, #ocTrialForm').find('.submitBtn').prop("disabled", false);
                }
            });
        }
    });

    $("#addon_install").submit((e) => {
        e.preventDefault();
        const site = $("select[name='site']").val();
        const addon = $("input[name='addon']").val();
        $.ajax({
            type: 'POST',
            url: '/api/add-addon',
            data: {site, addon},
            success: (response) => {
                Swal.fire({
                    icon: 'success',
                    title: installationStart,
                    timerProgressBar: true,
                    showConfirmButton: false,
                    timer: 1500
                })
            },
            error: (err) => {
                Swal.fire({
                    icon: 'error',
                    title: addAddonError,
                    timerProgressBar: true,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
    })
    $('.tryFormOnlyEmail').on('submit', function (e) {
        e.preventDefault();
        $('#freetrialForm').find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
        $('#freetrialForm').modal('toggle');
    });
    let site;
    $('.activation-action-btn').on('click', function () {
        $('.activation-errors').html('').addClass('d-none')
        $('.activation-action-btn').prop('disabled', true)
        let data = {
            verification_code: '' + $('#digit-1').val() + $('#digit-2').val() + $('#digit-3').val() + $('#digit-4').val() + $('#digit-5').val() + $('#digit-6').val(),
            email: $('#freeTrialModal input[name="email"]').val(),
            store_name: $('#freeTrialModal input[name="subdomain"]').val(),
        }
        $('.digit-input').prop('disabled', true)
        $.ajax({
            url: '/ajax/userVerification',
            method: 'get',
            data: data,
            accept: 'application/json',
            success: (response) => {
                $('.activation-errors').html('').addClass('d-none')
                if (!response.success) {
                    if (response.error_code === 422) {
                        $('.activation-errors').html(response.message).removeClass('d-none')
                    }
                    $('.digit-input').prop('disabled', false)
                }
                if (response.success) {
                    site = response.data.site
                    setProgressInterval(site)
                    $('.fourth_step, .fifth_step').toggleClass('d-none');
                }
            },
            error: (error) => {
                if (error.status === 422) {
                    $('.digit-input').prop('disabled', true)
                    $('.activation-action-btn').prop('disabled', false)
                    $('.activation-errors').html(error.responseJSON.errors.verification_code[0]).removeClass('d-none')
                }
            }
        })
    })

    function checkSiteStatus(site) {
        return new Promise((resolve, reject) => {
            return $.ajax({
                url: '/ajax/get-site-status/' + site.site_id,
                method: 'get',
                data: {
                    email: site.email,
                    code: site.code
                },
                accept: 'application/json',
                success: (response) => {
                    if (response.success) {
                        if (response.data.status === 'completed') {
                            resolve(response.data.site)
                        }
                        reject()
                    }
                },
                error: () => {
                    reject()
                }
            })
        })
    }

    function setProgressInterval(site) {
        let c = 0;
        let progressInterval = setInterval(function () {
            if (c < 99) {
                c = c + 1
                $('#installingProgressBar').html(c + '%')
                $('.progress-bar').css('width', c + '%')
            }
            checkSiteStatus(site).then(response => {
                c = 100;
                $('#installingProgressBar').html(c + '%')
                $('.progress-bar').css('width', c + '%')
                completeProgress(response).then(() => {
                    setTimeout(function () {
                        $('.fifth_step').addClass('d-none')
                        $('.sixth_step').removeClass('d-none')
                        clearInterval(progressInterval)
                    }, 5000);
                })
            })
        }, 3000)
    }

    function completeProgress(response) {
        return new Promise((resolve) => {
            $('.sixth_step .site-url').html(response.url)
            $('.sixth_step .open-site').attr('href', response.address)
            $('.sixth_step #email-address').html(response.email)
            $('.sixth_step #site-password').html(response.password)
            $('.sixth_step .site-admin-login').attr('href', response.admin_login)
            setTimeout(function () {
                resolve()
            }, 2000)
        })
    }
});

function timerResend() {
    let second = 120;

    $('.resend-verify').attr('disabled', true);
    countdown("verify-countdown", 0, second);
    setTimeout(function () {
        $('.resend-verify').attr('disabled', false);
    }, second * 1000);
}

function countdown(elementName, minutes, seconds) {
    var element, endTime, hours, mins, msLeft, time;

    function twoDigits(n) {
        return (n <= 9 ? "0" + n : n);
    }

    function updateTimer() {
        msLeft = endTime - (+new Date);
        if (msLeft < 1000) {
            element.innerHTML = "";
        } else {
            time = new Date(msLeft);
            hours = time.getUTCHours();
            mins = time.getUTCMinutes();
            element.innerHTML = (hours ? hours + ':' + twoDigits(mins) : mins) + ':' + twoDigits(time.getUTCSeconds());
            setTimeout(updateTimer, time.getUTCMilliseconds() + 500);
        }
    }

    element = document.getElementById(elementName);
    endTime = (+new Date) + 1000 * (60 * minutes + seconds) + 500;
    updateTimer();
}
