<?php namespace Visiosoft\SiteModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\AddAddonForm\AddAddonFormBuilder;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\ActivatedSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\Form\SiteFormBuilder;
use Visiosoft\SiteModule\Site\Notification\CompletedSiteCreate;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SiteController extends AdminController
{

    private $site;
    private $domain;
    private $addon;

    public function __construct(SiteRepositoryInterface $site, DomainRepositoryInterface $domain, AddonRepositoryInterface $addon)
    {
        $this->site = $site;
        $this->domain = $domain;
        $this->addon = $addon;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param SiteTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SiteTableBuilder $table)
    {
        $table->setColumns([
            'subdomain_name' => [
                'value' => function (EntryInterface $entry) {
                    if (!is_null($entry->suspend_at)) {
                        return $entry->subdomain_name . " <i class='fa fa-eye-slash'></i>";
                    }
                    return $entry->subdomain_name;
                },
            ],
            'assign',
            'update_at',
            'type'
        ]);
        $table->addButtons([
            'addAddon' => [
                'text' => 'visiosoft.module.site::button.addAddon',
                'href' => route('site::addAddon') . '?site={entry.id}',
                'icon' => 'fa fa-plus',
                'type' => 'info'
            ],
            'status' => [
                'text' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return "visiosoft.module.site::button.install_site";
                    } elseif ($entry->status == "completed") {
                        return "visiosoft.module.site::button.active";
                    } else {
                        return "visiosoft.module.site::button.pending";
                    }
                },
                'href' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return '/admin/subscriptions/completed/' . $entry->id;
                    } else
                        return "#";

                },
                'type' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return "warning";
                    } elseif ($entry->status == "completed") {
                        return "success";
                    } else {
                        return "default";
                    }
                },
                'icon' => function (EntryInterface $entry) {
                    if ($entry->status == "incomplete") {
                        return "fa fa-credit-card-alt";
                    } elseif ($entry->status == "completed") {
                        return "fa fa-check";
                    } else {
                        return "fa fa-clock-o";
                    }
                },],]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SiteFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function create(SiteFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * @param AddAddonFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function addAddon(AddAddonFormBuilder $form)
    {
        return $form->render();
    }

    public function check()
    {
        $activated = array();
        $pending = $this->site->newQuery()->where('status', '!=', 'completed')->get();
        foreach ($pending as $site) {
            $result = $this->events->dispatch(new CheckActivatedSite($site));
            if (!is_null($result) and isset($result[0]['result']) and $result[0]['result'] == "SUCCESS") {
                $site->update(['enabled' => true, 'status' => 'completed']);
                $activated[] = "$site->subdomain_name";
                event(new ActivatedSite($site));
            }
        }
        return $this->redirect->to('/admin/site');
    }
}
