<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\ActivatedSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;

class SiteController extends ResourceController
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
        parent::__construct();
    }

    public function activateSites()
    {
        $activated = array();
        $pending = $this->site->newQuery()->where('enabled', false)->get();
        foreach ($pending as $site) {
            $result = $this->events->dispatch(new CheckActivatedSite($site));
            if (isset($result[0]['result']) and $result[0]['result'] == "SUCCESS") {
                $site->update(['enabled' => true]);
                $activated[] = "$site->subdomain_name";
                event(new ActivatedSite($site));
            }
        }
        return response()->json($activated);
    }
}
