<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\UpdateSite;
use Visiosoft\SiteModule\Site\Table\SiteTableBuilder;


class Update extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, array $selected)
    {
        foreach ($selected as $id) {

            $site = $site->newQuery()->where('status', 'completed')->find($id);
            if ($site) {
                event(new UpdateSite($site));
                $site->update(['update_at' => date('Y-m-d H:i:s')]);
            }
        }
        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.updated', ['count' => count($selected)]));
        }
    }
}