<?php namespace Visiosoft\SiteModule\Site;

use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\SiteModule\Site\Event\SuspendSite;

class SiteRepository extends EntryRepository implements SiteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SiteModel
     */
    protected $model;

    /**
     * Create a new SiteRepository instance.
     *
     * @param SiteModel $model
     */
    public function __construct(SiteModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $subdomain
     * @return mixed
     */
    public function findBySubdomain($subdomain)
    {
        if (!is_null($sites = $this->newQuery()->where('subdomain_name', $subdomain)->get())) {
            return $sites->first();
        }
        return null;
    }


    public function unsuspend($id)
    {
        if (!is_null($site = $this->newQuery()->withTrashed()->where('suspend_at', '!=', null)->find($id))) {
            $site->update
            ([
                'suspend_at' => null,
                'deleted_at' => null,
            ]);
            event(new SuspendSite($site, "false"));
        }
    }

    public function findByAssing($user_id, $type = null)
    {
        $query = $this->newQuery()
            ->where('assign_id', $user_id);
        if (!is_null($type)) {
            $query = $query->where('status', $type);
        }
        return $query->get();
    }

    public function editDomain($domain)
    {
        $domain = str_replace('http://', '', $domain);
        $domain = str_replace('https://', '', $domain);
        $domain = str_replace('www.', '', $domain);

        return $domain;
    }

    public function getSiteForSubscription($id)
    {
        return $this->newQuery()->where('subscription_id', $id)->get();
    }

    /**
     * @param $subdomain
     * @param $user
     * @param $password
     * @return \Anomaly\Streams\Platform\Model\EloquentModel|mixed
     */
    public function createSite($subdomain, $user, $password, $params = [])
    {
        return $this->create(array_merge([
            'subdomain_name' => $subdomain,
            'assign' => $user,
            'password' => $password,
            'status' => 'incomplete'
        ], $params));
    }

    /**
     * @param $day
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Query\Builder[]|\Illuminate\Support\Collection|mixed
     */
    public function getUnguidedSitesWithDay($day)
    {
        return $this->newQuery()
            ->where('status', 'completed')
            ->whereDate('created_at', date('Y-m-d', strtotime("-" . $day . " days")))
            ->where('guide_mail', false)
            ->get();
    }

    /**
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection
     */
    public function getPendingSites()
    {
        return $this->newQuery()
            ->whereIn('status', ['incomplete', 'pending'])
            ->get();
    }
}
