<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Jobs\ChangeBackupStatus;
use Visiosoft\SiteModule\Site\Jobs\CreateSiteHandler;

class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder, MessageBag $message, SiteRepositoryInterface $siteRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        //Get Entry Before Saving
        $entry_before_saving = $siteRepository->find($builder->getFormEntryId());

        $builder->saveForm();

        //Get Entry After Saving
        $entry = $builder->getFormEntry();

        if ($builder->getFormMode() === 'create') {

            CreateSiteHandler::dispatch($entry, $builder->getPostValue('app'));
        }

        //Check Change Backup Status
        if ($entry_before_saving and $entry_before_saving->backup_status != $entry->backup_status) {
            ChangeBackupStatus::dispatch($entry);
        }
    }
}
