<?php namespace Visiosoft\SiteModule\Site\Form;

class SiteFormFields
{
    public function handle(SiteFormBuilder $builder)
    {
        if ($builder->getFormMode() === 'edit') {
            $builder->setFields([
                'status' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => [
                            'completed' => 'module::field.completed',
                            'error' => 'module::field.error',
                            'pending' => 'module::field.completed',
                            'incomplete' => 'module::field.incomplete',
                        ],
                    ],
                ],
                'message',
                'update_at',
                'suspend_at',
                'deletedCwp',
            ]);
        } else {
            $builder->setFields([
                'subdomain_name' => [
                    'config' => [
                        'max' => 8,
                    ],
                ],
                'type',
                'assign',
                'password'
            ]);
        }

    }
}
