<?php namespace Visiosoft\SiteModule\Site\AddSslForm;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class AddSslFormFields
{
    public function handle(AddSslFormBuilder $builder, DomainRepositoryInterface $domainRepository,SiteRepositoryInterface $siteRepository)
    {

        $site_id = request('site',null);

        if ($site_id && $site = $siteRepository->find($site_id))
        {
            $domains = $domainRepository->getDomainsBySite([request('site')])->pluck('domain','id')->all();

            $domains[] = $site->getUrl();

            $builder->setFields(
                [
                    'domains' => [
                        'type' => 'anomaly.field_type.checkboxes',
                        'config' => [
                            'options' => $domains
                        ],
                    ],
                ]
            );
        }
    }
}
