<?php namespace Visiosoft\SiteModule\Site\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Container\Container;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\BuildSubSite;
use Visiosoft\SiteModule\Site\Event\CreateSiteOnManuel;
use Visiosoft\SiteModule\Site\Event\CreatingSite;
use Visiosoft\SiteModule\Site\Event\ErrorCreateSite;
use Visiosoft\SiteModule\Site\SiteRepository;

class CreateSiteHandler implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $site;

    public $app;

    public $tries = 1;

    public function __construct($site, $app)
    {
        $this->site = $site;
        $this->app = $app;
    }

    public function handle(SiteRepository $siteRepository, Container $container)
    {
        $entry = $this->site;

        $status = $container->call('\Visiosoft\CwpModule\Commands\CwpCheckAccount@handle', ['site' => $entry]);

        if ($status) {
            $entry = $this->updateSubdomain($entry);
        }

        if ($this->app) {
            $app_site = $siteRepository->find($this->app);

            $entry->setAttribute('type', $app_site->type());
            $entry->save();

            $response = array_first(event(new BuildSubSite($entry)));
        } else {
            $response = array_first(event(new BuildSite($entry)));
        }

        if (!$response['status']) {
            $entry->updateErrorMsg($response['message']);

            event(new ErrorCreateSite($entry));
        } else {
            event(new CreatingSite($entry));

            $response_subscription = array_first(event(new CreateSiteOnManuel($entry)));

            if ($response_subscription) {
                $entry->setSubscription($response_subscription->id);
            }
        }
    }

    public function updateSubdomain($entry)
    {
        $container = app(Container::class);
        $subdomain = (strlen($entry->subdomain_name) > 6) ? substr($entry->subdomain_name, 0, 6) : $entry->subdomain_name;

        for ($i = 1; $i <= 20; $i++) {
            $entry->setAttribute('subdomain_name', $subdomain . $i);
            $entry->save();

            $status = $container->call('\Visiosoft\CwpModule\Commands\CwpCheckAccount@handle', ['site' => $entry]);

            if (!$status) {
                break;
            }
        }

        return $entry;
    }
}
