<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendedSite;
use Visiosoft\SiteModule\Site\Event\SuspendSite;


class Suspend extends ActionHandler
{
    public function handle(SiteRepositoryInterface $site, array $selected, MessageBag $message)
    {
        foreach ($selected as $id) {
            $site = $site->newQuery()
                ->where('suspend_at', null)
                ->whereIn('status', ['completed', 'pending'])
                ->find($id);

            if ($site) {
                $response = array_first(event(new SuspendSite($site, 'true')));
                $url = $site->subdomain_name . "." . $site->type;

                if (!$response['status']) {
                    $site->updateError($response['message']);


                    $message->error(trans('visiosoft.module.site::message.error_suspend', ['url' => $url]));
                } else {
                    $site->update(['suspend_at' => date('Y-m-d H:i:s'),]);

                    $message->success(trans('visiosoft.module.site::message.suspended', ['url' => $url]));

                    event(new SuspendedSite($site));
                }
            }
        }
    }
}