<?php namespace Visiosoft\SiteModule\Site;

use Visiosoft\SiteModule\Site\Contract\SiteInterface;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;

class SiteModel extends SiteSiteEntryModel implements SiteInterface
{

    public function getUrl()
    {
        return $this->subdomain_name.".".$this->type;
    }

    public function changeStatus($status)
    {
        $this->update(['status' => $status]);
    }

    public function updateError($message)
    {
        $this->update([
            'message' => $message,
            'status' => "error",
        ]);
    }

    public function setSubscription($id)
    {
        $this->update(['subscription_id' => $id,]);
    }

}
