<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\subscriptions\ErrorSuspendSiteForSubscription;
use Visiosoft\SiteModule\Site\Event\subscriptions\SuspendedSiteForSubscription;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SubscriptionsModule\Subscription\Event\SuspendedSubscription;

class SubscriptionExpired
{
    private $site;
    private $user;
    private $message;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user, MessageBag $message)
    {
        $this->site = $site;
        $this->user = $user;
        $this->message = $message;
    }

    public function handle(SuspendedSubscription $event)
    {
        $subscription = $event->getSubscription();

        $sites = $this->site->getSiteForSubscription($subscription->id);

        foreach ($sites as $site) {
            $response = array_first(event(new SuspendSite($site, 'true')));
            $url = $site->subdomain_name . "." . $site->type;

            if (!$response['status']) {
                $site->updateError($response['message']);

                event(new ErrorSuspendSiteForSubscription($site));

                $this->message->error(trans('visiosoft.module.site::message.error_suspend', ['url' => $url]));
            } else {
                $site->update([
                    'suspend_at' => date('Y-m-d H:i:s'),
                ]);

                $this->message->success(trans('visiosoft.module.site::message.suspended', ['url' => $url]));

                event(new SuspendedSiteForSubscription($site));
            }
        }
    }
}
