<?php namespace Visiosoft\SiteModule\Site\AddAddonForm;

use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;


class AddAddonFormHandler
{
    public function handle(
        AddAddonFormBuilder $builder,
        SiteRepositoryInterface $site,
        CustomFieldRepositoryInterface $cf,
        AddonRepositoryInterface $addon
    )
    {

        if (!$builder->canSave()) {
            return;
        }

        $parameters = $builder->getPostData();

        if ($site = $site->find($parameters['subdomain'])) {
            if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $parameters['addon'])) {

                event(new AddAddonSite($site, $is_addon));

                $addon->create([
                    'subdomain' => $site,
                    'addon' => $is_addon,
                    'payment' => false,
                    'installed' => 'pending'
                ]);
            }
        }
    }
}
