<?php namespace Visiosoft\CloudsiteModule\Site\Form;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\CloudsiteModule\Site\Event\last3days;


class SiteFormHandler
{
    public function handle(SiteFormBuilder $builder,Dispatcher $events,SettingRepositoryInterface $settingRepository) {

        if (!$builder->canSave()) {
            return;
        }
        $request = $builder->getPostData();
        $events->dispatch(new last3days($request,$settingRepository));
        $builder->saveForm();
    }
}
