<?php namespace Visiosoft\SiteModule\Console;

use Illuminate\Console\Command;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;

class CheckRefreshSites extends Command
{
    protected $name = 'check:refresh-sites';

    public function handle(SiteRepositoryInterface $siteRepository,CustomFieldRepositoryInterface $cf)
    {
        $sites = $siteRepository->getAutoRefresh();

        foreach ($sites as $site) {
            $site->reinstall();

            foreach ($site->reinstall_addons as $addon) {
                if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $addon->id)) {
                    event(new AddAddonSite($site, $is_addon));
                }
            }

        }
    }
}
