<?php namespace Visiosoft\SiteModule\Console;

use Illuminate\Console\Command;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\Event\CompletedInstallationSite;


class CheckActivateSites extends Command
{
    protected $name = 'check:activate-sites';

    public function handle(SiteRepositoryInterface $siteRepository, BundleRepositoryInterface $bundleRepository, CustomFieldRepositoryInterface $cf)
    {
        $activated = array();

        $pending_sites = $siteRepository->newQuery()->whereIn('status', ['incomplete', 'pending'])->get();

        foreach ($pending_sites as $site) {
            $result = array_first(event(new CheckActivatedSite($site)));
            if ($result) {
                $site->changeStatus('completed');

                $activated[] = "$site->subdomain_name";

                event(new CompletedInstallationSite($site));

                $install_addons = [
                    ["type" => 'module', "name" => 'demodata'],
                    ["type" => 'extension', "name" => 'ads_widget'],
                    ["type" => 'extension', "name" => 'ads_chart_widget'],
                ];

                if ($site->default_theme && $bundle = $bundleRepository->find($site->default_theme)) {
                    foreach ($bundle->addons as $addon) {
                        $addon_cf_name = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $addon->id);
                        $addon_array = explode('-', $addon_cf_name);
                        $install_addons[] = ['type' => $addon_array[1], 'name' => $addon_array[0]];
                    }
                } else {
                    $install_addons[] = ['type' => 'theme', 'name' => 'sahibinden'];
                }

                event(new AddMultipleAddonSite($site, $install_addons));
            }
        }
    }
}
