<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\BuildSite;
use Visiosoft\SiteModule\Site\Event\BuildSubSite;
use Visiosoft\SiteModule\Site\Event\webhook\ErrorBuildingSiteForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreatedForActivatedUser;

class CreatedNewSubscriptionForActivatedUser
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionCreatedForActivatedUser $event)
    {
        $subscription = $event->getSubscription();

        $user = $event->getSubscription()->getUser();

        $sites = $this->site->getSitesByAssign($user->getId());

        $site = $sites->first();

        //Check Site
        $site->changeStatus('pending', ['subscription_id' => $subscription->getId()]);

        if ($site->app) {
            $response = array_first(event(new BuildSubSite($site)));
        } else {
            $response = array_first(event(new BuildSite($site)));
        }
        if (!$response['status']) {
            $site->updateErrorMsg($response['message']);

            event(new ErrorBuildingSiteForWebhook($site));
        }
    }
}
