<?php namespace Visiosoft\SiteModule\Site\Listener\webhook;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\UnSuspendedSite;
use Visiosoft\SiteModule\Site\Event\webhook\ErrorUnsuspendSiteForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\UpgradeSubscription;

class UpgradeSubscriptionForWebhook
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(UpgradeSubscription $event)
    {
        $old_subscription = $event->getOldSubscription();
        $new_subscription = $event->getNewSubscription();

        $sites = $this->site->getSiteForSubscription($old_subscription->getId());

        foreach ($sites as $site) {
            $site->setAttribute('subscription_id', $new_subscription->getId());
            $site->save();

            if (in_array($site->status, ['completed', 'pending']) and $site->suspend_at and is_null($site->deletedCwp)) {

                $response = array_first(event(new SuspendSite($site, "false")));

                if ($response['status']) {
                    //Unsuspeded Success

                    event(new UnSuspendedSite($site));

                    $site->update([
                        'suspend_at' => null,
                        'deleted_at' => null
                    ]);

                } else {

                    //UnSuspended Failed
                    $site = $site->update(['message' => $response['message']]);

                    event(new ErrorUnsuspendSiteForWebhook($site));
                }
            }
        }
    }
}
