<?php namespace Visiosoft\SiteModule\Site\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class SiteFormBuilder extends FormBuilder
{
    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.site::js/admin/form.js',
        ],
        'styles.css' => [
            'visiosoft.module.site::css/admin/site/form.css',
        ],
    ];

    public function setOptions($options)
    {
        return parent::setOptions([
            'success_message' => false,
            'redirect' => '/admin/site',
            'title' => 'visiosoft.module.site::button.new_site',
            'description' => setting_value('visiosoft.module.site::form_description')
        ]);
    }

}
