<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CartsModule\Cart\Event\PaymentPending;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Addon\AddonRepository;
use Anomaly\Streams\Platform\Model\Site\SiteAddonEntryModel;
use Visiosoft\SiteModule\Addon\AddonModel;
use Visiosoft\SiteModule\Addon\Listener\PaymentSuccessAddon;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Domain\DomainRepository;
use Anomaly\Streams\Platform\Model\Site\SiteDomainEntryModel;
use Visiosoft\SiteModule\Domain\DomainModel;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Listener\CreatedNewSubscriptionForActivatedUser;
use Visiosoft\SiteModule\Site\Listener\SubscriptionDeleted;
use Visiosoft\SiteModule\Site\Listener\SubscriptionExpired;
use Visiosoft\SiteModule\Site\Listener\SubscriptionSuspended;
use Visiosoft\SiteModule\Site\Listener\SubscriptionUnSuspended;
use Visiosoft\SiteModule\Site\Listener\webhook\CreatedNewSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\DeletedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\FailedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\RenewedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\Listener\webhook\SuspendedSubscriptionForWebhook;
use Visiosoft\SiteModule\Site\SiteRepository;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;
use Visiosoft\SiteModule\Site\SiteModel;
use Illuminate\Routing\Router;
use Visiosoft\SubscriptionsModule\Subscription\Event\DeletedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\ExpiredSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreatedForActivatedUser;
use Visiosoft\SubscriptionsModule\Subscription\Event\SuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\UnSuspendedSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionCreatedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionDeletedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionFailedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionSuspendForWebhook;

class SiteModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        SiteModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/site/addon' => [
            'as' => 'visiosoft.module.site::admin.addon.list',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@index',
        ],
        'admin/addon/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@checkAddon',
        'admin/site/addon/installation/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@AddonInstall',
        'admin/site/domain' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@index',
        'admin/site/domain/create' => [
            'as' => 'visiosoft.module.site::admin.domain.create',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\DomainController@create',
        ],
        'admin/site' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@index',
        'admin/site/create' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@create',
        'admin/site/check' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@check',
        'admin/site/add-addon' => [
            'as' => 'visiosoft.module.site::admin.add.addon',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@addAddon'
        ],
        'profile/mysites/add-domain/{id}' => [
            'as' => 'add-domain',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@addDomain',
        ],
        'site/create' => 'Visiosoft\SiteModule\Http\Controller\SiteController@createNew',

        'ajax/registerUser' => [
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@registerUser',
        ],
        'addon/addCart' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@addCart',
        'admin/ajax/getAddonsForSite/{id}' => 'Visiosoft\SiteModule\Http\Controller\Admin\AddonController@getAddonListForSite',
        'admin/site/complete-on-manuel/{id}' => [
            'as' => 'visiosoft.module.site::admin.complete.on.manuel',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\Admin\SiteController@completeOnManuel',
        ],
        'installation-started' => [
            'as' => 'visiosoft.module.site::installation.started',
            'uses' => 'Visiosoft\SiteModule\Http\Controller\SiteController@installationStarted',
        ],

        //Cron
        'cron/pendingSites' => 'Visiosoft\SiteModule\Http\Controller\SiteController@activateSites',
        'cron/cronGuide' => 'Visiosoft\SiteModule\Http\Controller\SiteController@cronGuide',
        'cron/checkAddon' => 'Visiosoft\SiteModule\Http\Controller\AddonsController@checkAddon',
        'site/cron/auto-refresh' => 'Visiosoft\SiteModule\Http\Controller\SiteController@autorefresh',


    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SiteModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SiteModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        SubscriptionCreatedForWebhook::class => [
            CreatedNewSubscriptionForWebhook::class
        ],
        SubscriptionRenewedForWebhook::class => [
            RenewedSubscriptionForWebhook::class
        ],
        SubscriptionSuspendForWebhook::class => [
            SuspendedSubscriptionForWebhook::class
        ],
        SubscriptionFailedForWebhook::class => [
            FailedSubscriptionForWebhook::class
        ],
        SubscriptionDeletedForWebhook::class => [
            DeletedSubscriptionForWebhook::class,
        ],
        SuspendedSubscription::class => [
            SubscriptionSuspended::class
        ],
        UnSuspendedSubscription::class => [
            SubscriptionUnSuspended::class
        ],
        DeletedSubscription::class => [
            SubscriptionDeleted::class,
        ],
        ExpiredSubscription::class => [
            SubscriptionExpired::class
        ],

//        SubscriptionEnabled::class => [
//            UnSuspendSubscription::class
//        ],
//        SubscriptionDeleted::class => [
//            DeletedSubscription::class
//        ],
        PaymentSuccess::class => [
            PaymentSuccessAddon::class
        ],

        SubscriptionCreatedForActivatedUser::class => [
            CreatedNewSubscriptionForActivatedUser::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SiteModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SiteAddonEntryModel::class => AddonModel::class,
        SiteDomainEntryModel::class => DomainModel::class,
        SiteSiteEntryModel::class => SiteModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        AddonRepositoryInterface::class => AddonRepository::class,
        DomainRepositoryInterface::class => DomainRepository::class,
        SiteRepositoryInterface::class => SiteRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
